<?php
// Configuration file paths
$dbInfoFile = 'pages/dbInfo.php';
$configFile = 'auth/config.php';

// Check if the setup has been done
if (!file_exists($dbInfoFile) || !file_exists($configFile)) {
    header('Location: install.php');
    exit;
}

// If setup is done, include the database connection file
include 'pages/dbInfo.php';

// You can now use the connect_database function if needed
$con = connect_database();

// Now you can display your index page content
include 'auth/function.php';


?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>PaglaUPI - 0% FEE, Fast & Safe UPI Payment API</title>
  
  <!-- Favicon -->
  <link rel="shortcut icon" href="myassets/images/favicon.png" type="image/x-icon">
  
  <!-- CSS Framework -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  
  <!-- Custom CSS -->
  <link rel="stylesheet" href="myassets/css/style.css">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="myassets/css/font-awesome.min.css">
  
  <!-- Meta Tags -->
  <meta name="description" content="PaglaUPI - Ultimate UPI Payment API with 0% transaction fee. Fast, secure, and easy to integrate payment solution for your business.">
  <meta name="keywords" content="UPI Payment, Payment API, 0% transaction fee, digital payments, online payments">
  <meta name="author" content="PaglaUPI">
  
  <!-- Open Graph Meta Tags -->
  <meta property="og:title" content="PaglaUPI - 0% FEE UPI Payment API">
  <meta property="og:description" content="Accept payments directly to your bank account with 0% transaction fee. Easy integration for WordPress, Android apps, and all websites.">
  <meta property="og:type" content="website">
  <meta property="og:url" content="https://PaglaUPI">
  <meta property="og:image" content="myassets/images/og-image.png">
  
  <!-- Twitter Card Meta Tags -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="PaglaUPI - 0% FEE UPI Payment API">
  <meta name="twitter:description" content="Accept payments directly to your bank account with 0% transaction fee.">
  <meta name="twitter:image" content="myassets/images/og-image.png">
</head>

<body class="bg-gray-900 text-white overflow-x-hidden">
  <!-- Preloader -->
  <div id="preloader" class="preloader">
    <div class="preloader-logo"></div>
  </div>

  <div class="site-wrapper">
    <!-- ======== Navigation ======== -->
    <nav class="navbar fixed top-0 w-full z-50 transition-all duration-300">
      <div class="container mx-auto px-4">
        <div class="flex items-center justify-between h-16">
          <!-- Logo -->
          <div class="flex items-center">
            <a href="#" class="flex items-center space-x-2">
              <img src="<?php echo $site_settings['logo_url']; ?>" alt="<?php echo $site_settings['brand_name']; ?>" class="h-8 w-auto">
            </a>
          </div>

          <!-- Desktop Navigation -->
          <div class="hidden md:flex items-center space-x-8">
            <a href="#" class="nav-link active">Home</a>
            <a href="#about" class="nav-link">About</a>
            <a href="#features" class="nav-link">Features</a>
            <div class="relative group">
              <a href="#" class="nav-link flex items-center space-x-1">
                <span>Resources</span>
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                </svg>
              </a>
              <div class="absolute top-full left-0 mt-2 w-48 bg-gray-800 bg-opacity-95 backdrop-blur-lg rounded-xl shadow-2xl border border-gray-700 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300">
                <a href="#" class="block px-4 py-2 text-sm text-gray-300 hover:text-white hover:bg-gray-700 rounded-t-xl">API Documentation</a>
                <a href="#" class="block px-4 py-2 text-sm text-gray-300 hover:text-white hover:bg-gray-700">Postman Docs</a>
                <a href="#" class="block px-4 py-2 text-sm text-gray-300 hover:text-white hover:bg-gray-700">Privacy Policy</a>
                <a href="#" class="block px-4 py-2 text-sm text-gray-300 hover:text-white hover:bg-gray-700">Refund Policy</a>
                <a href="#" class="block px-4 py-2 text-sm text-gray-300 hover:text-white hover:bg-gray-700 rounded-b-xl">Terms & Conditions</a>
              </div>
            </div>
          </div>

          <!-- CTA Button -->
          <div class="hidden md:flex items-center space-x-4">
            <a href="auth/index" class="btn-primary">Login / Register</a>
          </div>

          <!-- Mobile Menu Button -->
          <button id="mobile-menu-button" class="md:hidden p-2">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
            </svg>
          </button>
        </div>
      </div>
    </nav>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="mobile-menu">
      <button id="mobile-menu-close" class="absolute top-4 right-4 p-2">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
        </svg>
      </button>
      <div class="flex flex-col items-center space-y-8">
        <a href="#" class="mobile-menu-item">Home</a>
        <a href="#about" class="mobile-menu-item">About</a>
        <a href="#features" class="mobile-menu-item">Features</a>
        <a href="auth/index" class="mobile-menu-item">Login</a>
        <a href="register" class="mobile-menu-item">Register</a>
      </div>
    </div>

    <!-- ======== Hero Section ======== -->
    <section class="hero-section pt-16">
      <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center min-h-screen">
          <!-- Left Column -->
          <div class="space-y-8 fade-in">
            <div class="space-y-6">
              <h1 class="text-5xl lg:text-6xl font-bold text-white text-shadow">
                The Ultimate <span class="text-gradient">UPI Payment</span> Solution
              </h1>
              <p class="text-xl text-gray-300 leading-relaxed">
                Accept Payments Directly to your Bank Account At 0% Transaction Fee. Easy To Use! WordPress Website! Android App! All Websites
              </p>
              <div class="flex flex-col sm:flex-row gap-4">
                <a href="register" class="btn-primary">Get Started</a>
                <a href="#features" class="btn-secondary">Learn More</a>
              </div>
            </div>
            
            <!-- Social Proof -->
            <div class="space-y-4">
              <h3 class="text-lg font-semibold text-gray-300">Over <span class="text-gradient font-bold stat-counter">5000</span>+ Reviews</h3>
              <div class="flex items-center space-x-4">
                <div class="flex -space-x-2">
                  <img src="myassets/images/reviewImg_1.webp" alt="Review 1" class="w-10 h-10 rounded-full border-2 border-gray-700">
                  <img src="myassets/images/reviewImg_2.webp" alt="Review 2" class="w-10 h-10 rounded-full border-2 border-gray-700">
                  <img src="myassets/images/reviewImg_3.webp" alt="Review 3" class="w-10 h-10 rounded-full border-2 border-gray-700">
                </div>
                <div class="flex items-center space-x-2">
                  <div class="flex text-yellow-400">
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                  </div>
                  <span class="text-gray-300">4.9/5 Rating</span>
                </div>
              </div>
            </div>
          </div>

          <!-- Right Column -->
          <div class="relative fade-in-right">
            <div class="relative">
              <img src="myassets/images/upi.svg" alt="UPI Payment" class="w-full h-auto float-animation">
              
              <!-- Floating Stats -->
              <div class="absolute top-4 right-4 bg-gray-800 bg-opacity-80 backdrop-blur-lg rounded-2xl p-4 shadow-xl">
                <div class="text-center">
                  <div class="text-2xl font-bold text-gradient stat-counter">93000</div>
                  <div class="text-sm text-gray-400">Satisfied Users</div>
                </div>
              </div>
              
              <div class="absolute bottom-4 left-4 bg-gray-800 bg-opacity-80 backdrop-blur-lg rounded-2xl p-4 shadow-xl">
                <div class="text-center">
                  <div class="text-2xl font-bold text-gradient stat-counter">99</div>
                  <div class="text-sm text-gray-400">% Secure Payments</div>
                </div>
              </div>
              
              <div class="absolute top-1/2 left-4 bg-gray-800 bg-opacity-80 backdrop-blur-lg rounded-2xl p-4 shadow-xl">
                <div class="text-center">
                  <div class="text-2xl font-bold text-gradient">4.9</div>
                  <div class="text-sm text-gray-400">Client Rating</div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- ======== Partners Section ======== -->
    <section id="about" class="py-16 border-t border-gray-800">
      <div class="container mx-auto px-4">
        <div class="text-center mb-12">
          <h2 class="text-2xl font-semibold text-gray-300">Our Solution Partners</h2>
        </div>
        <div class="flex flex-wrap justify-center items-center gap-8 opacity-60">
          <img src="myassets/images/icons/logo-smarthub.svg" alt="SmartHub" class="partner-logo">
          <img src="myassets/images/icons/sbi.png" alt="SBI" class="partner-logo">
          <img src="myassets/images/icons/Amazon_Pay_logo.svg.png" alt="Amazon Pay" class="partner-logo">
          <img src="myassets/images/icons/freecharge.png" alt="FreeCharge" class="partner-logo">
          <img src="myassets/images/icons/phonepe.png" alt="PhonePe" class="partner-logo">
          <img src="myassets/images/icons/paytm.png" alt="Paytm" class="partner-logo">
          <img src="myassets/images/icons/bharatpay.png" alt="BharatPay" class="partner-logo">
          <img src="myassets/images/icons/mobikwik.png" alt="MobiKwik" class="partner-logo">
        </div>
      </div>
    </section>

    <!-- ======== Features Section ======== -->
    <section class="py-20 bg-gray-900">
      <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
          <!-- Left Column - Features -->
          <div class="space-y-8">
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
              <div class="card card-hover fade-in">
                <div class="feature-icon">
                  <i class="fa-solid fa-percentage"></i>
                </div>
                <h3 class="text-xl font-semibold mb-3">0% Transaction Charge</h3>
                <p class="text-gray-400">No charges of any kind will be deducted for <?php echo $site_settings['brand_name']; ?> Payments</p>
              </div>
              
              <div class="card card-hover fade-in">
                <div class="feature-icon">
                  <i class="fa-solid fa-bolt"></i>
                </div>
                <h3 class="text-xl font-semibold mb-3">Fast Transactions</h3>
                <p class="text-gray-400"><?php echo $site_settings['brand_name']; ?> Payment processes payments like a rocket.</p>
              </div>
              
              <div class="card card-hover fade-in">
                <div class="feature-icon">
                  <i class="fa-solid fa-code"></i>
                </div>
                <h3 class="text-xl font-semibold mb-3">Developer Friendly</h3>
                <p class="text-gray-400">You can easily integrate <?php echo $site_settings['brand_name']; ?> Payment API.</p>
              </div>
              
              <div class="card card-hover fade-in">
                <div class="feature-icon">
                  <i class="fa-solid fa-headset"></i>
                </div>
                <h3 class="text-xl font-semibold mb-3">24/7 Support</h3>
                <p class="text-gray-400"><?php echo $site_settings['brand_name']; ?> Payment offers dedicated WhatsApp support.</p>
              </div>
            </div>
          </div>

          <!-- Right Column - Content -->
          <div class="space-y-8 fade-in-right">
            <div class="space-y-6">
              <h2 class="text-4xl font-bold text-white">
                Your Money, Your Way, <span class="text-gradient">Our Guarantee</span>
              </h2>
              <p class="text-lg text-gray-300 leading-relaxed">
                <?php echo $site_settings['brand_name']; ?> Payment API does not hold your money for even a second, it provides you the service of instant settlement so that your money remains safe. So do not delay, register immediately on <?php echo $site_settings['brand_name']; ?> Payment API and use our very advanced features.
              </p>
              <a href="register" class="btn-primary inline-block">Get Started Now</a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- ======== Registration Steps Section ======== -->
    <section id="features" class="py-20 bg-gradient-to-br from-gray-900 to-gray-800">
      <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
          <!-- Left Column - Content -->
          <div class="space-y-8 fade-in">
            <div class="space-y-6">
              <h2 class="text-4xl font-bold text-white">
                Our Easy Steps For <span class="text-gradient">Registration</span>
              </h2>
              <p class="text-lg text-gray-300 leading-relaxed">
                <?php echo $site_settings['brand_name']; ?> Payment API is a secure, fast, and user-friendly platform that simplifies digital transactions. Whether you're a business owner or an individual user, <?php echo $site_settings['brand_name']; ?> offers an all-in-one solution for managing your financial activities with ease.
              </p>
            </div>
            
            <!-- Features Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
              <div class="space-y-4">
                <div class="flex items-center space-x-3">
                  <div class="w-2 h-2 bg-blue-500 rounded-full"></div>
                  <span class="text-white font-medium">Instant Payment Processing</span>
                </div>
                <div class="flex items-center space-x-3">
                  <div class="w-2 h-2 bg-blue-500 rounded-full"></div>
                  <span class="text-white font-medium">High-Level Data Encryption</span>
                </div>
                <div class="flex items-center space-x-3">
                  <div class="w-2 h-2 bg-blue-500 rounded-full"></div>
                  <span class="text-white font-medium">Enjoy Full Access</span>
                </div>
              </div>
              <div class="space-y-4">
                <div class="flex items-center space-x-3">
                  <div class="w-2 h-2 bg-purple-500 rounded-full"></div>
                  <span class="text-white font-medium">Real-time Transaction Tracking</span>
                </div>
                <div class="flex items-center space-x-3">
                  <div class="w-2 h-2 bg-purple-500 rounded-full"></div>
                  <span class="text-white font-medium">Easy Integration for Businesses</span>
                </div>
                <div class="flex items-center space-x-3">
                  <div class="w-2 h-2 bg-purple-500 rounded-full"></div>
                  <span class="text-white font-medium">Your Own Branding</span>
                </div>
              </div>
            </div>
            
            <!-- CTA Buttons -->
            <div class="flex flex-col sm:flex-row gap-4">
              <a href="register" class="btn-primary">Register Now</a>
              <a href="auth/index" class="btn-secondary">Login</a>
            </div>
          </div>

          <!-- Right Column - Visual -->
          <div class="relative fade-in-right">
            <div class="relative">
              <img src="myassets/images/card2.png" alt="Payment Interface" class="w-full h-auto">
              
              <!-- Floating Stats -->
              <div class="absolute top-8 right-8 bg-gray-800 bg-opacity-80 backdrop-blur-lg rounded-2xl p-4 shadow-xl">
                <div class="flex items-center space-x-3">
                  <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center">
                    <i class="fa-solid fa-arrow-down text-white text-sm"></i>
                  </div>
                  <div>
                    <div class="text-sm text-gray-400">Incomes</div>
                    <div class="text-lg font-bold text-white">₹ <span class="stat-counter">2750</span>.50</div>
                  </div>
                </div>
              </div>
              
              <div class="absolute bottom-8 right-8 bg-gray-800 bg-opacity-80 backdrop-blur-lg rounded-2xl p-4 shadow-xl">
                <div class="flex items-center space-x-3">
                  <div class="w-8 h-8 bg-red-500 rounded-full flex items-center justify-center">
                    <i class="fa-solid fa-arrow-up text-white text-sm"></i>
                  </div>
                  <div>
                    <div class="text-sm text-gray-400">Expenses</div>
                    <div class="text-lg font-bold text-white">₹ <span class="stat-counter">1240</span>.75</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- ======== 1.8. Testimonials section (IMB Payment API) ======== -->
    <section class="Testimonials">
      <div class="container">
        <div class="row">
          <!-- Left Content Section -->
          <div class="col-md-6 col-lg-6">
            <div class="d-flex flex-column gap-4 h-100 justify-content-center position-relative" data-aos="fade-up">
              <h2>What Our Clients Say About <?php echo $site_settings['brand_name']; ?></h2>
              <p><?php echo $site_settings['brand_name']; ?> Payment API has earned the trust of thousands of businesses across India. Here's what our users are saying about their experience with our platform.</p>
              <div class="d-flex flex-row">
                <div class="d-flex flex-column">
                  <h3><span class="number" data-final-value="93"></span>k+</h3>
                  <p>Trusted Businesses</p>
                </div>
                <div class="d-flex flex-column">
                  <h3><span class="number" data-final-value="4.9"></span>/5</h3>
                  <p>User Rating</p>
                </div>
                <div class="d-flex flex-column">
                  <h3><span class="number" data-final-value="100"></span>k+</h3>
                  <p>Successful Integrations</p>
                </div>
              </div>
            </div>
          </div>
    
          <!-- Right Testimonials Section -->
          <div class="col-md-6 col-lg-6">
            <div class="d-flex flex-column ps-lg-5 justify-content-between pt-5 pt-md-0">
    
              <!-- Testimonial 1 -->
              <div class="d-flex gap-4 align-items-center position-relative" data-aos="fade-up">
                <figure class="position-absolute">
                  <img loading="lazy" src="myassets/images/icons/comma.svg" alt="comma">
                </figure>
                <figure>
                  <img loading="lazy" src="myassets/images/testimonial_1.webp" alt="Ravi Mehta">
                </figure>
                <div class="d-flex flex-column gap-1">
                  <div>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                  </div>
                  <div class="py-md-1">
                    <h6>Ravi Mehta</h6>
                    <p>Founder, QuickKart</p>
                  </div>
                  <p class="p-0">"<?php echo $site_settings['brand_name']; ?>'s seamless integration and real-time dashboard helped us scale our business effortlessly. Transactions are fast and secure!"</p>
                </div>
              </div>
    
              <!-- Testimonial 2 -->
              <div class="d-flex gap-4 align-items-center position-relative" data-aos="fade-up">
                <figure class="position-absolute">
                  <img loading="lazy" src="myassets/images/icons/comma.svg" alt="comma">
                </figure>
                <figure>
                  <img loading="lazy" src="myassets/images/reciever.webp" alt="Shweta Kapoor">
                </figure>
                <div class="d-flex flex-column gap-1">
                  <div>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                  </div>
                  <div class="py-md-1">
                    <h6>Shweta Kapoor</h6>
                    <p>Developer, FinBox</p>
                  </div>
                  <p class="p-0">"The developer-friendly API and excellent documentation made integration smooth. <?php echo $site_settings['brand_name']; ?>'s support team is always responsive!"</p>
                </div>
              </div>
    
              <!-- Testimonial 3 -->
              <div class="d-flex gap-4 align-items-center position-relative" data-aos="fade-up">
                <figure class="position-absolute">
                  <img loading="lazy" src="myassets/images/icons/comma.svg" alt="comma">
                </figure>
                <figure>
                  <img loading="lazy" src="myassets/images/testimonial_3.webp" alt="Aman Jain">
                </figure>
                <div class="d-flex flex-column gap-1">
                  <div>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                  </div>
                  <div class="py-1">
                    <h6>Aman Jain</h6>
                    <p>Freelancer</p>
                  </div>
                  <p class="p-0">"With <?php echo $site_settings['brand_name']; ?>, I can easily accept payments from my clients. The transparent pricing and instant settlements are a big plus!"</p>
                </div>
              </div>
    
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.8. Testimonials section ======== -->
    <br><br><br><br><br>

    <!-- ======== 1.7. Benefits section ======== -->
    <section class="Benefits">
      <div class="container">
        <div class="row">
          <div class="col-lg-5">
            <figure class="position-relative pt-5 pt-lg-0" data-aos="zoom-in-up">
              <img loading="lazy" src="myassets/images/card2.png" class="w-100" alt="mobile">
            </figure>
          </div>
          <div class="col-lg-7">
            <div
              class="d-flex flex-column h-100 gap-md-5 gap-4 justify-content-between justify-content-xl-start pb-lg-0 pb-5"
              data-aos="fade-up">
              <h2>You Can Receive Money On Your <span>Finger Tips</span></h2>
              <div class="d-flex gap-0 position-relative">
                <div class="d-flex flex-column gap-5">
                  <div class="d-flex flex-column gap-3">
                    <h5>John Smith Sending</h5>
                    <div class="d-flex gap-4 align-items-center">
                      <figure>
                        <img loading="lazy" src="myassets/images/sender.webp" alt="sender">
                      </figure>
                      <p>₹ <span class="number" data-final-value="466.53"></span></p>
                    </div>
                  </div>
                  <div class="d-flex flex-column gap-3">
                    <h5>William Recieving</h5>
                    <div class="d-flex gap-4 align-items-center">
                      <figure>
                        <img loading="lazy" src="myassets/images/reciever.webp" alt="reciever">
                      </figure>
                      <p>₹ <span class="number" data-final-value="466.53"></span></p>
                    </div>
                  </div>
                </div>
                <div class="d-flex flex-column py-4">
                  <figure>
                    <img loading="lazy" src="myassets/images/icons/indian.png" alt="flag">
                  </figure>
                  <figure class="d-flex align-items-center justify-content-center">
                    <img loading="lazy" src="myassets/images/icons/telegram.png" alt="telegram">
                  </figure>
                  <figure>
                    <img loading="lazy" src="myassets/images/icons/indian.png" alt="flag">
                  </figure>
                </div>
                <div class="position-absolute p-4 d-flex align-items-center gap-3">
                  <div>
                    <figure>
                      <i class="fa-solid fa-check"></i>
                    </figure>
                  </div>
                  <p>Your Payment has been successful</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.7. Benefits section ======== -->

    <!-- ======== End of 1.10. Blog section ======== -->
    <br><br><br><br><br>
    <!-- ======== 1.11. FAQs section (IMB Payment API) ======== -->
    <section class="FAQs">
      <div class="container">
        <div class="row">
          <div class="col-md-6 col-lg-7">
            <div data-aos="fade-up">
              <h2>Frequently Asked <span>Questions</span></h2>
              <p><?php echo $site_settings['brand_name']; ?> Payment API is a secure and efficient solution for processing online transactions. Here are some frequently asked questions to help you understand how it works.</p>
              <div>
                <div class="accordion accordion-flush d-flex flex-column" id="accordionExample">
                  
                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                        What is <?php echo $site_settings['brand_name']; ?> Payment API?
                      </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p><?php echo $site_settings['brand_name']; ?> Payment API is an online payment processing platform that allows businesses to accept credit/debit cards, UPI, net banking, and digital wallets securely.</p>
                      </div>
                    </div>
                  </div>

                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                        Is <?php echo $site_settings['brand_name']; ?> Payment API secure?
                      </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p>Yes, <?php echo $site_settings['brand_name']; ?> Payment API uses advanced encryption and is PCI-DSS compliant to ensure all transactions are safe and secure.</p>
                      </div>
                    </div>
                  </div>

                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                        How long does it take to settle payments?
                      </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p>Typically, settlements are done within T+1 working days, where 'T' is the transaction date.</p>
                      </div>
                    </div>
                  </div>

                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                        What payment methods are supported?
                      </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p><?php echo $site_settings['brand_name']; ?> supports multiple payment methods including credit cards, debit cards, UPI, net banking, and wallets like Paytm, PhonePe, and Google Pay.</p>
                      </div>
                    </div>
                  </div>

                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                        How can I integrate <?php echo $site_settings['brand_name']; ?> Payment API on my website?
                      </button>
                    </h2>
                    <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p>You can integrate it easily using <?php echo $site_settings['brand_name']; ?>'s APIs or ready-to-use plugins for platforms like WordPress, Shopify, and Magento. Detailed documentation is available on our developer portal.</p>
                      </div>
                    </div>
                  </div>

                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-lg-5">
            <figure class="position-relative pt-md-0 pt-5" data-aos="zoom-in">
              <img loading="lazy" src="myassets/images/faqsGirl.webp" alt="IMB FAQs">
            </figure>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.11. FAQs section ======== -->

    <!-- ======== 1.12. Footer section ======== -->
    <footer>
      <div class="container">

        <div class="d-flex justify-content-between w-100">
          <div class="z-1 d-flex align-items-md-start align-items-center text-md-start text-center flex-column">
            <figure>
              <a href="index">
                <img loading="lazy" src="<?php echo $site_settings['logo_url']; ?>" alt="logo">
              </a>
            </figure>
            <p class="m-0">Free <?php echo $site_settings['brand_name']; ?> Payment API in India with, 0% Transaction charges, easy Accept payments online via UPI Qr payment and save on transaction charges. </p>

          </div>
          <div
            class="d-flex flex-column gap-lg-4 d-flex align-items-md-start align-items-center text-md-start text-center ms-0">
            <h5>Contact US</h5>
            <ul>
              <li>
                WhatsApp:
                <a href="https://wa.me/91<?php echo $site_settings['whatsapp_number']; ?>">
                  <span class="d-block">+91 <?php echo $site_settings['whatsapp_number']; ?></span></a>
              </li>
            </ul>
          </div>
          <div
            class="d-flex gap-md-3 flex-column p-0 d-flex align-items-md-start align-items-center text-md-start text-center">
            <h5>Get Started</h5>
            <p>We suggest start using today.</p>
            <div class="d-flex gap-lg-3 gap-md-3">
              <a href="auth/index">
                <div class="d-flex gap-lg-3 gap-2 justify-content-center align-items-center" style="padding-left: 20px; padding-right: 20px;">
                  <div>
                    <p>Existing user?</p>
                    <h6>Login</h6>
                  </div>
                </div>
              </a>
              <a href="register">
                <div class="d-flex gap-lg-3 gap-2 justify-content-center align-items-center" style="padding-left: 20px; padding-right: 20px;">
                  <div>
                    <p>New User?</p>
                    <h6>Register</h6>
                  </div>
                </div>
              </a>
            </div>
          </div>
        </div>
        <div class="w-100 text-center py-lg-4 py-3">
          <p>Copyright &copy; <script>document.write(new Date().getFullYear())</script> <?php echo $site_settings['brand_name']; ?> Payment. All Rights Reserved.</p>
        </div>
      </div>
      <!-- scroll to top  -->
      <div class="scrollToTop">
        <div class="arrowUp">
          <i class="fa-solid fa-arrow-up"></i>
        </div>
        <div class="water">
          <svg viewBox="0 0 560 20" class="water_wave water_wave_back">
            <use xlink:href="#wave"></use>
          </svg>
          <svg viewBox="0 0 560 20" class="water_wave water_wave_front">
            <use xlink:href="#wave"></use>
          </svg>
          <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 560 20" style="display: none;">
            <symbol id="wave">
              <path
                d="M420,20c21.5-0.4,38.8-2.5,51.1-4.5c13.4-2.2,26.5-5.2,27.3-5.4C514,6.5,518,4.7,528.5,2.7c7.1-1.3,17.9-2.8,31.5-2.7c0,0,0,0,0,0v20H420z">
              </path>
              <path
                d="M420,20c-21.5-0.4-38.8-2.5-51.1-4.5c-13.4-2.2-26.5-5.2-27.3-5.4C326,6.5,322,4.7,311.5,2.7C304.3,1.4,293.6-0.1,280,0c0,0,0,0,0,0v20H420z">
              </path>
              <path
                d="M140,20c21.5-0.4,38.8-2.5,51.1-4.5c13.4-2.2,26.5-5.2,27.3-5.4C234,6.5,238,4.7,248.5,2.7c7.1-1.3,17.9-2.8,31.5-2.7c0,0,0,0,0,0v20H140z">
              </path>
              <path
                d="M140,20c-21.5-0.4-38.8-2.5-51.1-4.5c-13.4-2.2-26.5-5.2-27.3-5.4C46,6.5,42,4.7,31.5,2.7C24.3,1.4,13.6-0.1,0,0c0,0,0,0,0,0l0,20H140z">
              </path>
            </symbol>
          </svg>
        </div>
      </div>
    </footer>
    <!-- ======== End of 1.12. Footer section ======== -->
  </div>
  
  
  <body oncontextmenu="return false">

  <!-- bootstrap min javascript -->
  <script src="myassets/js/bootstrap.min.js"></script>
  <!-- j Query -->
  <script src="myassets/js/jquery.js"></script>
  <!-- slick slider js -->
  <script src="myassets/js/slick.min.js"></script>
  <!-- main javascript -->
  <script src="myassets/js/custom.js"></script>
  <!-- animation from javascript -->
  <script src="myassets/js/aos.js"></script>
  
  <script disable-devtool-auto="" src="common/disable-devtool.js" data-url="https://www.google.com/"></script>

</body>

</html>